\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ktufbethesis}[2025/04/26 v1.7 KTÜ FBE Turkish Thesis Template]

\LoadClass[12pt, a4paper, openany]{book}
\usepackage{multirow}
\usepackage[a4paper, top=3cm, bottom=2.5cm, inner=3cm, outer=2.5cm, twoside=false]{geometry}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{newtxtext, newtxmath}
\usepackage{setspace}
\usepackage{lipsum}
\usepackage[normalem]{ulem}
\onehalfspacing
\usepackage{indentfirst}
\setlength{\parindent}{1cm}
\setlength{\parskip}{0pt}
\usepackage{titlesec}
\usepackage{algorithm}

% List spacing configuration to match 1.5 line spacing
\usepackage{enumitem}

\setlist{itemsep=0.5\baselineskip, parsep=0pt, topsep=0.5\baselineskip, partopsep=0pt}



\usepackage[justification=centering,font={singlespacing}]{caption}
\titleformat{\chapter}
  [hang]
  {\normalfont\normalsize\bfseries\raggedright}
  {\hspace{1cm}\thechapter.\ }
  {0cm}
  {}

\titlespacing*{\chapter}
  {0pt}
  {1cm}
  {18pt}
  
\titleformat{\section}
  [hang]
  {\normalfont\normalsize\bfseries\raggedright}
  {\hspace{1cm}\thesection.\ }
  {0pt}
  {}

\titlespacing*{\section}
  {1cm}
  {30pt}
  {18pt}

  
\titleformat{\subsection}
  [hang]
  {\normalfont\normalsize\bfseries\raggedright}
  {\hspace{1cm}\thesubsection.\ }
  {0cm}
  {}

\titleformat{\subsubsection}
[hang]
{\normalfont\normalsize}  % NO bold (as you requested)
{\hspace{1cm}\textbullet\ }  % Text-mode bullet (more reliable than $\bullet$)
{0pt}
{$\bullet$ \hspace{1em} }

\titlespacing*{\subsubsection}
{0pt}
{30pt}
{18pt}
\newenvironment{fbesekilnosp}{%
  \shorthandoff{=}%
  \begin{figure}[!ht]% Try here first, then top
  \centering
}{%
  \end{figure}%
  \shorthandon{=}%
  \vspace{-15pt}% Explicitly set no extra spacing
}
\titlespacing*{\subsection}
  {0pt}
  {30pt}
  {18pt}

\titleformat{name=\chapter,numberless}
  [display]
  {\normalfont\normalsize\bfseries\centering}
  {}
  {0pt}
  {}
  
\titlespacing*{name=\chapter,numberless}
  {0pt}
  {1cm}
  {18pt}
  
\usepackage{etoolbox}

\newenvironment{fbesekil}[1][htbp]{%
  \shorthandoff{=}%
  \begin{figure}[#1]%
  \centering
}{%
  \end{figure}%
  \shorthandon{=}%
}

\AtBeginEnvironment{figure}{\singlespacing}
\AtBeginEnvironment{table}{\singlespacing}
\usepackage{footmisc}
\renewcommand{\footnotelayout}{\singlespacing}
\usepackage[english, turkish]{babel}
\usepackage{ifthen}
\usepackage{tocloft}
\renewcommand{\cftchapleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftsecleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftsubsecleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftfigleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cfttableader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftfigpresnum}{Şekil }
\setlength{\cftfignumwidth}{5em}  % Adjust width to accommodate "Şekil X"

% Add "Tablo" prefix to table numbers in List of Tables (for consistency)
\renewcommand{\cfttabpresnum}{Tablo }
\setlength{\cfttabnumwidth}{5em} % Adjust width to 


\usepackage{fancyhdr}
\usepackage{graphicx}
\usepackage[absolute]{textpos}
\usepackage{datetime}

\fancypagestyle{mainbodystyle}{
    \fancyhf{} \fancyhead[C]{\thepage} \renewcommand{\headrulewidth}{0pt} \renewcommand{\footrulewidth}{0pt}
}

\fancypagestyle{frontmatterstyle}{
    \fancyhf{} \fancyfoot[C]{\thepage} \renewcommand{\headrulewidth}{0pt} \renewcommand{\footrulewidth}{0pt}
}

\fancypagestyle{plainwithpagenumber}{
   \fancyhf{} \fancyfoot[C]{\thepage} \renewcommand{\headrulewidth}{0pt} \renewcommand{\footrulewidth}{0pt}
}

\fancypagestyle{plain}{
   \fancyhf{} \renewcommand{\headrulewidth}{0pt} \renewcommand{\footrulewidth}{0pt}
}

\pagestyle{empty}

\let\oldfrontmatter\frontmatter
\renewcommand{\frontmatter}{
    \oldfrontmatter
    \setcounter{page}{3}  % Account for 3 cover pages
    \pagestyle{frontmatterstyle}
    \renewcommand{\thepage}{\Roman{page}}
    \fancypagestyle{plain}{\fancypagestyle{plainwithpagenumber}}
}

\let\oldmainmatter\mainmatter
\renewcommand{\mainmatter}{
    \oldmainmatter 
    \pagestyle{mainbodystyle} 
    \renewcommand{\thepage}{\arabic{page}}
    \fancypagestyle{plain}{
        \fancyhf{} \renewcommand{\headrulewidth}{0pt} \renewcommand{\footrulewidth}{0pt}
    }
}

\newcommand{\thesisTitle}[1]{\gdef\@thesisTitle{#1}\gdef\plainThesisTitle{#1}}
\newcommand{\thesisEnglishTitle}[1]{\gdef\@thesisEnglishTitle{#1}\gdef\plainThesisEnglishTitle{#1}}
\newcommand{\thesisAuthor}[1]{\gdef\@thesisAuthor{#1}\gdef\plainThesisAuthor{#1}}
\newcommand{\thesisKeywords}[1]{\gdef\@thesisKeywords{#1}\gdef\plainThesisKeywords{#1}}
\newcommand{\thesisKeywordsEnglish}[1]{\gdef\@thesisKeywordsEnglish{#1}\gdef\plainThesisKeywordsEnglish{#1}}
\newcommand{\thesisDegree}[1]{\gdef\@thesisDegree{#1}\gdef\plainThesisDegree{#1}}
\newcommand{\thesisUniversity}[1]{\gdef\@thesisUniversity{#1}\gdef\plainThesisUniversity{#1}}
\newcommand{\thesisInstitute}[1]{\gdef\@thesisInstitute{#1}\gdef\plainThesisInstitute{#1}}
\newcommand{\thesisDepartment}[1]{\gdef\@thesisDepartment{#1}\gdef\plainThesisDepartment{#1}}
\newcommand{\thesisUniversityEnglish}[1]{\gdef\@thesisUniversityEnglish{#1}\gdef\plainThesisUniversityEnglish{#1}}
\newcommand{\thesisInstituteEnglish}[1]{\gdef\@thesisInstituteEnglish{#1}\gdef\plainThesisInstituteEnglish{#1}}
\newcommand{\thesisDepartmentEnglish}[1]{\gdef\@thesisDepartmentEnglish{#1}\gdef\plainThesisDepartmentEnglish{#1}}
\newcommand{\thesisSupervisor}[1]{\gdef\@thesisSupervisor{#1}\gdef\plainThesisSupervisor{#1}}
\newcommand{\thesisDate}[1]{\gdef\@thesisDate{#1}\gdef\plainThesisDate{#1}} % Tam tarih için
\newcommand{\juryMemberOne}[1]{\gdef\@juryMemberOne{#1}\gdef\plainJuryMemberOne{#1}}
\newcommand{\juryMemberTwo}[1]{\gdef\@juryMemberTwo{#1}\gdef\plainJuryMemberTwo{#1}}
\newcommand{\juryMemberThree}[1]{\gdef\@juryMemberThree{#1}\gdef\plainJuryMemberThree{#1}}
\newcommand{\juryMemberFour}[1]{\gdef\@juryMemberFour{#1}\gdef\plainJuryMemberFour{#1}}
\newcommand{\juryMemberFive}[1]{\gdef\@juryMemberFive{#1}\gdef\plainJuryMemberFive{#1}}

\newcommand{\thesisLocation}[1]{\gdef\@thesisLocation{#1}\gdef\plainThesisLocation{#1}}
\newcommand{\thesisMonthYear}[1]{\gdef\@thesisMonthYear{#1}\gdef\plainThesisMonthYear{#1}}
\newcommand{\thesisYear}[1]{\gdef\@thesisYear{#1}\gdef\plainThesisYear{#1}}
\newcommand{\thesisLogoFile}[1]{\gdef\@thesisLogoFile{#1}\gdef\plainThesisLogoFile{#1}}
\newcommand{\thesisAuthorOrcid}[1]{\gdef\@thesisAuthorOrcid{#1}\gdef\plainThesisAuthorOrcid{#1}}
\newcommand{\thesisSubmissionDate}[1]{\gdef\@thesisSubmissionDate{#1}\gdef\plainThesisSubmissionDate{#1}}
\newcommand{\thesisDefenseDate}[1]{\gdef\@thesisDefenseDate{#1}\gdef\plainThesisDefenseDate{#1}}
\newcommand{\thesisSupervisorOrcid}[1]{\gdef\@thesisSupervisorOrcid{#1}\gdef\plainThesisSupervisorOrcid{#1}}
\newcommand{\thesisCoSupervisor}[1]{\gdef\@thesisCoSupervisor{#1}\gdef\plainThesisCoSupervisor{#1}}
\newcommand{\thesisCoSupervisorOrcid}[1]{\gdef\@thesisCoSupervisorOrcid{#1}\gdef\plainThesisCoSupervisorOrcid{#1}}
\newcommand{\thesisDirectorName}[1]{\gdef\@thesisDirectorName{#1}\gdef\plainThesisDirectorName{#1}}
\newcommand{\instituteJuryDate}[1]{\gdef\@instituteJuryDate{#1}\gdef\plainInstituteJuryDate{#1}}
\newcommand{\instituteJuryNr}[1]{\gdef\@instituteJuryNr{#1}\gdef\plainInstituteJuryNr{#1}}

\providecommand{\plainThesisTitle}{} \providecommand{\plainThesisAuthor}{} \providecommand{\plainThesisDegree}{}
\providecommand{\plainThesisDepartment}{} \providecommand{\plainThesisSupervisor}{} \providecommand{\plainThesisDate}{}
\providecommand{\plainThesisUniversity}{} \providecommand{\plainThesisInstitute}{} \providecommand{\plainJuryMemberOne}{}
\providecommand{\plainJuryMemberTwo}{} \providecommand{\plainJuryMemberThree}{} \providecommand{\plainJuryMemberFour}{}
\providecommand{\plainJuryMemberFive}{}

\providecommand{\plainThesisLocation}{} \providecommand{\plainThesisMonthYear}{} \providecommand{\plainThesisLogoFile}{}
\providecommand{\plainThesisAuthorOrcid}{} \providecommand{\plainThesisSubmissionDate}{} \providecommand{\plainThesisDefenseDate}{}
\providecommand{\plainThesisSupervisorOrcid}{} \providecommand{\plainThesisCoSupervisor}{} \providecommand{\plainThesisCoSupervisorOrcid}{}
\providecommand{\plainThesisDirectorName}{}

\newcommand{\plainProgramType}{%
    \ifthenelse{\equal{\plainThesisDegree}{Doktora Tezi}}
        {doktora}
        {yüksek lisans}%
}

\renewcommand{\thetable}{\arabic{table}}
\renewcommand{\thefigure}{\arabic{figure}}

\renewcommand{\theequation}{\arabic{equation}}
\usepackage{chngcntr}
\counterwithout{equation}{chapter}

\newcommand{\makeOuterCover}{%
  \thispagestyle{empty}
  \begin{textblock*}{\textwidth}(3cm, 4cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisUniversity} \\ \MakeUppercase{\plainThesisInstitute} \par}
  \end{textblock*}
  
  \begin{textblock*}{\textwidth}(3cm, 8cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisDepartment} ANABİLİM DALI \par}
  \end{textblock*}
  
  \begin{textblock*}{\textwidth}(3cm, 11cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisTitle} \par}
  \end{textblock*}
  
  \begin{textblock*}{\textwidth}(3cm, 18cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisDegree} \par}
  \end{textblock*}
  
  \begin{textblock*}{\textwidth}(3cm, 21cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisAuthor} \par}
  \end{textblock*}
  
  \begin{textblock*}{\textwidth}(3cm, 25cm)
    \centering
    {\normalsize \bfseries  \MakeUppercase{\plainThesisMonthYear} \\ \MakeUppercase{\plainThesisLocation} \par}
  \end{textblock*}
  
  \mbox{}
  \clearpage
}

\newcommand{\makeInnerCoverOne}{
  \thispagestyle{empty}
   \ifthenelse{\equal{\plainThesisLogoFile}{}}{}{
     \begin{textblock*}{\textwidth}(3cm, .75cm)
        \centering
        \includegraphics[height=3cm]{\plainThesisLogoFile}\par
     \end{textblock*}
   }

  \begin{textblock*}{\textwidth}(3cm, 4cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisUniversity} \\ \MakeUppercase{\plainThesisInstitute} \par}
  \end{textblock*}
  
  \begin{textblock*}{\textwidth}(3cm, 6.5cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisDepartment} ANABİLİM DALI \par}
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 8.5cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisTitle} \par}
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 13.5cm)
    \centering
    {\normalsize \bfseries \plainThesisAuthor \\ ORCID : \plainThesisAuthorOrcid \par}
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 16.5cm)
    \centering
    \ifthenelse{\equal{\plainThesisDegree}{Doktora Tezi}}{
      {
        \normalsize \bfseries 
           Karadeniz Teknik Üniversitesi Fen Bilimleri Enstitüsünce \\
           "DOKTOR (\MakeUppercase{\plainThesisDepartment})" \\
           Unvanı Verilmesi İçin Kabul Edilen Tezdir.
      }
    }{
      {
        \normalsize \bfseries 
           Karadeniz Teknik Üniversitesi Fen Bilimleri Enstitüsünce \\
           "YÜKSEK LİSANS (\MakeUppercase{\plainThesisDepartment})" \\
           Unvanı Verilmesi İçin Kabul Edilen Tezdir.
      }
    }
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 19.5cm)
   {
     \normalsize \bfseries
     \begin{center}
     \begin{tabular}{ll}
        Tezin Enstitüye Verildiği Tarih & : \plainThesisSubmissionDate{} \\
        Tezin Savunma Tarihi & : \plainThesisDefenseDate{} \\
     \end{tabular}
     \end{center}
   }
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 22cm)
    {
      \normalsize \bfseries
      \begin{center}
        \ifthenelse{\isundefined{\plainThesisCoSupervisor} \OR \equal{\plainThesisCoSupervisor}{}}
        {
        \begin{tabular}{ll}
          Tez Danışmanı & : \plainThesisSupervisor \\
          ORCID & : \plainThesisSupervisorOrcid \\
        \end{tabular}
        }
        {
        \begin{tabular}{ll}
          Tez Danışmanı & : \plainThesisSupervisor \\
          ORCID & : \plainThesisSupervisorOrcid \\
          İkinci Danışmanı & : \plainThesisCoSupervisor \\
          ORCID & : \plainThesisCoSupervisorOrcid
        \end{tabular}
        }
      \end{center}
    }
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 26cm)
    \centering
    {\normalsize \bfseries \plainThesisLocation{} \plainThesisYear{} \par}
  \end{textblock*}
   
  \mbox{}
  \clearpage
}

\newcommand{\makeInnerCoverTwo}{%
  \thispagestyle{empty}

  \begin{textblock*}{\textwidth}(3cm, 4cm)
    \centering
    {\normalsize \bfseries 
      \MakeUppercase{\plainThesisUniversity} \\ 
      \MakeUppercase{\plainThesisInstitute} \par
      }
      \vspace{.2cm}
     {\normalsize \bfseries 
      \plainThesisDepartment{} Anabilim Dalında \\
      \plainThesisAuthor{} Tarafından Hazırlanan
      } 
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 7.5cm)
    \centering
    {\normalsize \bfseries \MakeUppercase{\plainThesisTitle} \par}
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 10cm)
    \centering
    {
        \normalsize \bfseries 
        başlıklı bu çalışma Enstitü Yönetim Kurulunun \plainInstituteJuryDate{} gün ve \plainInstituteJuryNr{} sayılı \\
        kararıyla oluşturulan jüri tarafından yapılan sınavda \\
        \MakeUppercase{\plainThesisDegree} \\
        olarak kabul edilmiştir.
    }
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 17cm)
   {
        \normalsize \bfseries
        \ifthenelse{\equal{\plainThesisDegree}{Doktora Tezi}}
        {
        \begin{tabular}{ll@{\hspace{1cm}}l}
        \multicolumn{3}{l}{Jüri Üyeleri}\\
        \\
        Başkan &: \plainJuryMemberOne{} & \makebox[6cm]{\dotfill} \\
        \\
        Üye &: \plainJuryMemberTwo{}    &  \makebox[6cm]{\dotfill} \\
        \\
        Üye &: \plainJuryMemberThree{}  &  \makebox[6cm]{\dotfill} \\
        \\
        Üye &: \plainJuryMemberFour{}   &  \makebox[6cm]{\dotfill} \\
        \\
        Üye &: \plainJuryMemberFive{}   &  \makebox[6cm]{\dotfill} \\
        \end{tabular}
        }
        {
        \begin{tabular}{ll@{\hspace{1cm}}l}
        \multicolumn{3}{l}{Jüri Üyeleri}\\
        \\
        Başkan &: \plainJuryMemberOne{} & \makebox[6cm]{\dotfill} \\
        \\
        Üye &: \plainJuryMemberTwo{}    &  \makebox[6cm]{\dotfill} \\
        \\
        Üye &: \plainJuryMemberThree{}  &  \makebox[6cm]{\dotfill} \\
        \end{tabular}
        }
   }
  \end{textblock*}

  \begin{textblock*}{\textwidth}(3cm, 25cm)
    \centering
    {\normalsize \bfseries \plainThesisDirectorName{} \\ Enstitü Müdürü}
  \end{textblock*}

  \mbox{}
}

\newcommand{\makeAllCovers}{
  \makeOuterCover
  \makeInnerCoverOne
  \makeInnerCoverTwo
}

\usepackage{textcase}

\DeclareRobustCommand{\EnglishUppercase}[1]{
  \begingroup
  \selectlanguage{english}%
  \MakeTextUppercase{#1}%
  \endgroup
}
\newcommand{\tirnak}[1]{``#1''}

%\let\oldthebibliography\thebibliography
%\let\endoldthebibliography\endthebibliography
%\renewenvironment{thebibliography}[1]{
%   % Remove the chapter/section title
%   \chapter{KAYNAKLAR}
%   \addcontentsline{toc}{chapter}{KAYNAKLAR}
%   \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}%
%   % Continue with the regular bibliography formatting
%   \list{\@biblabel{\@arabic\c@enumiv}}%
%        {\settowidth\labelwidth{\@biblabel{#1}}%
%         \leftmargin\labelwidth
%         \advance\leftmargin\labelsep
%         \@openbib@code
%         \usecounter{enumiv}%
%         \let\p@enumiv\@empty
%         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
%   \singlespacing
%   \sloppy\clubpenalty4000\widowpenalty4000%
% }{\endlist}

\addto\captionsturkish{%
  \renewcommand{\listfigurename}{ŞEKİLLER DİZİNİ}
  \renewcommand{\listtablename}{TABLOLAR DİZİNİ}
  \renewcommand{\contentsname}{İÇİNDEKİLER}
}

%\renewcommand{\cfttoctitlefont}{
%\normalfont\normalsize\bfseries
%}

%\renewcommand{\cftaftertoctitle}{
%  \vspace{18pt}
%  \par
%  {\hfill\uline{\bfseries Sayfa \bfseries No}}
%  \par
%  \vspace{-1.5cm}
%}

%\renewcommand{\cftloftitlefont}{
%\normalfont\normalsize\bfseries
%}
%\renewcommand{\cftafterloftitle}{
%  \vspace{18pt}
%  \par
%  {\hfill\uline{\bfseries Sayfa \bfseries No}}
%  \par
%  \vspace{-1.5cm}
%}

\makeatletter
\newcommand{\icindekilertablosu}{
  \chapter*{\normalfont\normalsize\bfseries\centering \contentsname}
  \par
  {\hfill\uline{\bfseries Sayfa \bfseries No}}
  \par
  \addcontentsline{toc}{chapter}{\contentsname}
  \@starttoc{toc}
}
\makeatother

\makeatletter
\newcommand{\sekillerdizini}{
  \chapter*{\normalfont\normalsize\bfseries\centering \listfigurename}
  \par
  {\hfill\uline{\bfseries Sayfa \bfseries No}}
  \par
  \addcontentsline{toc}{chapter}{\listfigurename}
  \setlength{\cftbeforefigskip}{0.5\baselineskip}  % Add 1.5 line spacing between figure entries
  \@starttoc{lof}
}
\makeatother

\makeatletter
\newcommand{\tablolardizini}{
  \chapter*{\normalfont\normalsize\bfseries\centering \listtablename}
  \par
  {\hfill\uline{\bfseries Sayfa \bfseries No}}
  \par
  \addcontentsline{toc}{chapter}{\listtablename}
  \setlength{\cftbeforetabskip}{0.5\baselineskip}  % Add 1.5 line spacing between table entries
  \@starttoc{lot}
}
\makeatother

\newcommand{\calculateMainSectionPageCount}{\the\numexpr\getpagerefnumber{thesis:mainend}-\getpagerefnumber{thesis:mainstart}+1\relax}
\newcommand{\calculateBackSectionPageCount}{\the\numexpr\getpagerefnumber{thesis:backend}-\getpagerefnumber{thesis:backstart}+1\relax}

\newenvironment{ozet}{
  \clearpage
  \vspace*{\dimexpr 1cm - \topskip\relax}
  \begin{center}
     \normalsize
     \plainThesisDegree{}
     \\
     \vspace{18pt}
     {
       \bfseries
       ÖZET
     }
     \\
     \vspace{18pt}
     {
     \MakeUppercase{\plainThesisTitle}
     }
     \\
     \vspace{18pt}
     {
     \plainThesisAuthor{}
     }
     \\
     \vspace{24pt}
     {
         \plainThesisUniversity{}\\
         \plainThesisInstitute{}\\
         \plainThesisDepartment{} Anabilim Dalı\\
         Danışman: \plainThesisSupervisor{} \\
         \plainThesisYear{}, \calculateMainSectionPageCount{} Sayfa,
         \calculateBackSectionPageCount{} Sayfa Ek
     }
  \end{center}
  \par\addvspace{40pt}
  \addcontentsline{toc}{chapter}{ÖZET}
  \label{sec:ozet}
}{
  \vspace{48pt}
  \noindent
  \begingroup\onehalfspacing
  \begin{tabular}{p{.24\textwidth}p{.76\textwidth}}
     {\bfseries Anahtar Kelimeler :} & \plainThesisKeywords{}
  \end{tabular}
  \endgroup
}

\newenvironment{summary}{
  \clearpage
  \vspace*{\dimexpr 1cm - \topskip\relax}
  \begin{center}
     \normalsize
     \ifthenelse{\equal{\plainThesisDegree}{Doktora Tezi}}{PhD. Thesis}{Master Thesis}
     \\
     \vspace{18pt}
     {
       \bfseries
       SUMMARY
     }
     \\
     \vspace{18pt}
     {
     \EnglishUppercase{\plainThesisEnglishTitle}
     }
     \\
     \vspace{18pt}
     {
     \plainThesisAuthor{}
     }
     \\
     \vspace{24pt}
     {
         \plainThesisUniversityEnglish{}\\
         \plainThesisInstituteEnglish{}\\
         \plainThesisDepartmentEnglish{} Graduate Program\\
         Supervisor: \plainThesisSupervisor{} \\
         \plainThesisYear{}, \calculateMainSectionPageCount{} Pages,
         \calculateBackSectionPageCount{} Pages Appendix
     }
  \end{center}
  \par\addvspace{40pt}
  \addcontentsline{toc}{chapter}{SUMMARY}
  \label{sec:summary}
}{
  \vspace{48pt}
  \noindent
  \begingroup\onehalfspacing
  \begin{tabular}{p{.13\textwidth}p{.87\textwidth}}
     {\bfseries Keywords :} & \plainThesisKeywordsEnglish{}
  \end{tabular}
  \endgroup
  \clearpage
}

\newenvironment{onbolum}{
\makeAllCovers
\frontmatter
}{}

\newenvironment{anaicerik}{
\mainmatter
\label{thesis:mainstart}
}{
\label{thesis:mainend}
}

\newenvironment{sonkisim}{
\backmatter
\label{thesis:backstart}
}{
\label{thesis:backend}
}

\setlength{\cftchapindent}{0cm}
\setlength{\cftsecindent}{0.5cm}
\setlength{\cftsubsecindent}{1.5cm}

\renewcommand{\cftchapfont}{\normalfont}
\renewcommand{\cftchappagefont}{\normalfont}

\renewcommand{\cftsecfont}{\normalfont} 
\renewcommand{\cftsecpagefont}{\normalfont}

\renewcommand{\cftsubsecfont}{\normalfont} 
\renewcommand{\cftsubsecpagefont}{\normalfont}

\setlength{\cftbeforechapskip}{6pt}
\setlength{\cftbeforesecskip}{6pt}
\setlength{\cftbeforesubsecskip}{6pt}

\renewcommand{\cftchappresnum}{}
\renewcommand{\cftchapaftersnum}{.}

\renewcommand{\cftsecpresnum}{}
\renewcommand{\cftsecaftersnum}{.}

\renewcommand{\cftsubsecpresnum}{}
\renewcommand{\cftsubsecaftersnum}{.}

\usepackage[
 backend=biber,
 style=apa,
 sortcites=true,
 sorting=nyt,
 natbib=true,
 uniquename=false,
 uniquelist=false
]{biblatex}
\DeclareLanguageMapping{turkish}{turkish-apa}

\newcommand{\ktubibliography}[1]{%
   \clearpage
   \phantomsection
   \chapter{KAYNAKLAR}%
   \par
   \begingroup
     \singlespacing
     \setlength{\bibitemsep}{0.5\baselineskip}
     \printbibliography[heading=none]
   \endgroup
}

\usepackage{longtable}

% GLOSSARY PACKAGES AND SETUP
\usepackage[toc,nonumberlist,nogroupskip]{glossaries}
\usepackage{glossary-mcols}

% Set glossary styles
\setglossarystyle{long}
\setlength{\glsdescwidth}{0.7\textwidth}

% Turkish translations for glossary terms
\addto\captionsturkish{%
  \renewcommand{\glossaryname}{SEMBOLLER VE KISALTMALAR DİZİNİ}
  \renewcommand{\entryname}{Terim/Kısaltma/Simge}
  \renewcommand{\descriptionname}{Açıklama}
  \renewcommand{\pagelistname}{Sayfa}
}

% Enable glossary generation
\makeglossaries

% Custom unified glossary style to match thesis formatting
\newglossarystyle{ktuunified}{%
  \setglossarystyle{long}%
  \renewenvironment{theglossary}%
    {\thispagestyle{frontmatterstyle}\begin{longtable}{p{0.2\textwidth}p{0.75\textwidth}}}%
    {\end{longtable}}%
  \renewcommand*{\glossaryheader}{}%
  \renewcommand*{\glsgroupheading}[1]{}%
  \renewcommand{\glossentry}[2]{%
    \glsentryitem{##1}\glstarget{##1}{\glossentryname{##1}} & 
    : \glossentrydesc{##1}\glspostdescription\space ##2\tabularnewline
  }%
  \renewcommand{\subglossentry}[3]{%
    \glossentry{##2}{##3}%
  }%
}

% Command to display unified glossary with proper formatting
\newcommand{\ktuprintglossary}{%
  \clearpage % Start the glossary on a new page.
  
  % Explicitly set the page style and re-assert uppercase Roman page numbering
  % for the glossary section, especially its title page.
  \pagestyle{frontmatterstyle} 
  \renewcommand{\thepage}{\Roman{page}} % This is the key fix.
  
  \setglossarystyle{ktuunified} % Apply your custom glossary style.
  
  % Print the glossary. The [title=...] option makes it behave like a chapter,
  % which typically uses \thispagestyle{plain}. Your \frontmatter setup
  % correctly redefines 'plain' to use 'plainwithpagenumber', which in turn
  % uses \thepage. Ensuring \thepage is \Roman{page} here is crucial.
  \printglossary[title={\normalfont\normalsize\bfseries\centering \glossaryname}, toctitle={\glossaryname}]
  
  % It's good practice to ensure the next content starts on a new page,
  % and subsequent frontmatter pages will continue with the established frontmatterstyle.
  \clearpage 
  \renewcommand{\thepage}{\arabic{page}}
}

% Convenience commands for adding entries to the main glossary
\newcommand{\newglossaryterm}[3]{%
  \newglossaryentry{#1}{name={#2},description={#3}}
}

\newcommand{\newacronymterm}[3]{%
  \newglossaryentry{#1}{name={#2},description={#3 (#2)}}
}

\newcommand{\newsymbolterm}[3]{%
  \newglossaryentry{#1}{name={#2},description={#3}}
}
\newcounter{ktutablecolcount}
\makeatletter
\newcommand{\ktucountcols}[1]{%
\setcounter{ktutablecolcount}{0}%
\@tfor\@ktucoltmp:=#1\do{%
 \ifx\@ktucoltmp l\stepcounter{ktutablecolcount}\fi
 \ifx\@ktucoltmp c\stepcounter{ktutablecolcount}\fi
 \ifx\@ktucoltmp r\stepcounter{ktutablecolcount}\fi
 \ifx\@ktucoltmp p\stepcounter{ktutablecolcount}\fi
}%
}
\makeatother
% Define a new environment for customizable longtables with alignment
\newenvironment{ktufbeteztable}[6]
{% #1:Caption #2:Label #3:ColFormat #4:ColNames #5:ContText #6:Alignment
\ktucountcols{#3}%
\begin{longtable}[#6]{#3}
\caption{#1}
\label{#2}\\
\hline
\ifblank{#4}{}{#4 \\ \hline}
\endfirsthead
%
\multicolumn{\value{ktutablecolcount}}{l}%
{{#5}} \\ \hline
\ifblank{#4}{}{#4 \\ \hline}
\endhead
%
\hline
\endfoot
\hline
\endlastfoot
}
{% End part
\end{longtable}
}

\newcommand{\tabloref}[1]{Tablo~\ref{#1}}
\newcommand{\sekilref}[1]{Şekil~\ref{#1}}
\newcommand{\denklemref}[1]{Denklem~\ref{#1}}

\captionsetup[table]{skip=18pt}  % 18pt = 12pt × 1.5 for 1.5 line spacing
\captionsetup[figure]{skip=18pt}  % 18pt = 12pt × 1.5 for 1.5 line spacing

\usepackage{xcolor}
\usepackage{tcolorbox}
\newcommand{\subsubsectionstyle}[1]{%
\colorbox{black}{%
 \parbox{\dimexpr\textwidth-2\fboxsep\relax}{%
   \color{white}\bfseries\raggedright #1%
 }%
}%
}
\newlist{romenumerate}{enumerate}{4}
\setlist[romenumerate,1]{label=(\roman*)}

\endinput